/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOACP_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO ACP
    Task function list for configuration file

   Changes:

    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2010-04-07  B. Meyer     added instances of the interrupts and PHYs to the startup parameters
                                to fix mantis #8857

    2009-09-15  B. Meyer     added PHY names to startup parameters (mantis #7093)
                             changed startup parameter version to 3

    2009-05-28  B. Meyer     renamed  pszTimerIrqName  to  pszHWTimerName

    2009-05-21  B. Meyer     added new startup parameters and changed type of existing ones

**************************************************************************************/
/**
 * @file PNIOACP_Functionlist.h
 * @brief PNIO ACP - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNIOACP</code>
 * of task.
 */
#ifndef __PNIO_ACP_FUNCTIONLIST_H
#define __PNIO_ACP_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNIOACP
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_PNIOACP
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_RESULT
TaskEnter_PNIOACP
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_ACP_STARTUP_PARAM_VERSION_3 (3)
#define PNIO_ACP_STARTUP_PARAM_VERSION_4 (4)
#define PNIO_ACP_STARTUP_PARAM_VERSION_5 (5)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
typedef struct PNIO_ACP_STARTUPPARAMETER_V3_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /** EDD name
   *
   * The member defines the name of Ethernet device driver, which
   * handles the access to an Ethernet port.
   */
  TLR_STR*   pszEddName;

  /** maximum alarm protocol machines ALPMI & ALPMR
   *
   * The member defines the maximum number of alarm protocol machines.
   */
  TLR_UINT    uiMaxAlPm;

  /** RT Interrupt name
   *
   * The member defines the name of RT Interrupt to identify.
   */
  TLR_STR*   pszRTIrqName;

  /** Hardware Timer name
   *
   * The member defines the name of Hardware Timer identify.
   */
  TLR_STR*   pszHWTimerName;

  /** IRT MSYNC Interrupt name Channel 0
   *
   * The member defines the name of IRT MSync Interrupt of Channel 0 to identify.
   */
  TLR_STR*   pszIRTMSyncCh0Name;

  /** IRT MSYNC Interrupt name Channel 1
   *
   * The member defines the name of IRT MSync Interrupt of Channel 1 to identify.
   */
  TLR_STR*   pszIRTMSyncCh1Name;

  /** PHY 0 name
   *
   * The member defines the name of PHY device driver, which
   * handles the access to the PHY.
   */
  TLR_STR*   pszPhy0Name;

  /** PHY 1 name
   *
   * The member defines the name of PHY device driver, which
   * handles the access to the PHY
   */
  TLR_STR*   pszPhy1Name;

  /** RT Interrupt Instance
   *
   * The instance of the RT Interrupt
   */
  TLR_UINT32 ulRTIrqInstance;

  /** Hardware Timer Instance
   *
   * The instance of the Hardware Timer Interrupt.
   */
  TLR_UINT32 ulHWTimerInstance;

  /** IRT MSYNC Interrupt 0 instance
   *
   * The instance of the MotionSync Interrupt for Channel 0
   */
  TLR_UINT32 ulIRTMSyncCh0Instance;

  /** IRT MSYNC Interrupt 1 instance
   *
   * The instance of the MotionSync Interrupt for Channel 1
   */
  TLR_UINT32 ulIRTMSyncCh1Instance;

  /** PHY 0 instance
   *
   * The instance under which the PHY can be identified
   */
  TLR_UINT32 ulPhy0Instance;

  /** PHY 1 instance
   *
   * The instance under which the PHY can be identified
   */
  TLR_UINT32 ulPhy1Instance;

  /** LinkStatus Timer
   *
   * The amount of time the task shall wait before issuing a LinkStatus Change indication to higher level tasks
   */
  TLR_UINT32 ulLinkTimeout;

} PNIO_ACP_STARTUPPARAMETER_V3_T;

/** @} */

#define PNIO_ACP_STARTUP_DEFAULT_MAX_PM  (2)

/*************************************************************************************/
#endif /* #ifndef __PNIO_ACP_FUNCTIONLIST_H */
